// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: compile_blueprint
 * Compiles a Blueprint and returns compilation results.
 */
class FCompileBlueprintAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("compile_blueprint"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Compiles a Blueprint and returns the result (success/failure with error messages). "
			"Always compile after making changes to ensure the Blueprint is valid. "
			"Compilation errors should be fixed before further edits.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
