// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: add_variable
 * Adds a member variable to a Blueprint.
 */
class FAddVariableAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("add_variable"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Adds a new member variable to a Blueprint. "
			"Supported types: bool, int, float, double, string, text, name, byte, "
			"Vector, Rotator, Transform, Color, LinearColor, "
			"or any object/class type (use 'object:ClassName' format). "
			"Set is_array=true for array variables. "
			"You can set a default_value as a string.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
