// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: add_function
 * Adds a new function graph to a Blueprint.
 * Tracks the entry node and returns its node_id + pins so the AI can connect to it.
 */
class FAddFunctionAction : public IBlueprintAction
{
public:
	FAddFunctionAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("add_function"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Adds a new function graph to a Blueprint. "
			"Creates an empty function with optional input/output parameters. "
			"The function graph will contain a default entry node. "
			"After creating, use add_node and connect_nodes to build the function logic.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
