// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: add_component
 * Adds a component (StaticMesh, Collision, ProjectileMovement, etc.) to a Blueprint's
 * component hierarchy via the SimpleConstructionScript (SCS).
 */
class FAddComponentAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("add_component"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Adds a component to a Blueprint's component hierarchy. "
			"Common component_class values: StaticMeshComponent, SphereComponent, BoxComponent, CapsuleComponent, "
			"ArrowComponent, ProjectileMovementComponent, RotatingMovementComponent, AudioComponent, PointLightComponent, "
			"SpotLightComponent, ParticleSystemComponent, NiagaraComponent, WidgetComponent, SpringArmComponent, CameraComponent. "
			"Returns the component variable name for use with set_component_property. "
			"Use is_root=true to make it the default scene root.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
