// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: add_comment_box
 * Adds a comment box around nodes in a Blueprint graph.
 * The comment box visually groups nodes together with a colored rectangle and title.
 */
class FAddCommentBoxAction : public IBlueprintAction
{
public:
	FAddCommentBoxAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("add_comment_box"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Adds a comment box (colored rectangle) around nodes in a Blueprint graph. "
			"Pass node_ids to auto-size the box around those nodes, OR set position/size manually. "
			"Nodes inside the box will move together when the comment is dragged. "
			"Use get_selected_nodes first if you want to wrap the user's selected nodes.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
