// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "AI/OpenAIProvider.h"

/**
 * AI provider for the OpenRouter API.
 * OpenRouter uses the same format as OpenAI with extra HTTP headers.
 * Endpoint: https://openrouter.ai/api/v1/chat/completions
 */
class FOpenRouterProvider : public FOpenAIProvider
{
public:
	FOpenRouterProvider(const FString& InApiKey, const FString& InModel);

	virtual FString GetProviderName() const override { return TEXT("OpenRouter"); }

	virtual void SendRequest(
		const FAICompletionRequest& Request,
		FOnAIResponse OnResponse,
		FOnAIError OnError
	) override;

protected:
	virtual FString GetModelsEndpoint() const override;
	virtual TMap<FString, FString> GetAuthHeaders() const override;

private:
	FString RouterApiKey;
};
