// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "AI/AIProviderBase.h"
#include "Settings/BlueprintAISettings.h"

/**
 * Custom endpoint provider. Supports both Claude-format and OpenAI-format APIs,
 * configurable via Settings->CustomApiFormat.
 */
class FCustomProvider : public FAIProviderBase
{
public:
	FCustomProvider(
		const FString& InEndpoint,
		const FString& InApiKey,
		const FString& InModel,
		EAIProviderType InFormat
	);

	virtual FString GetProviderName() const override { return TEXT("Custom"); }
	virtual bool SupportsToolCalling() const override { return true; }

	virtual void SendRequest(
		const FAICompletionRequest& Request,
		FOnAIResponse OnResponse,
		FOnAIError OnError
	) override;

	virtual TSharedPtr<FJsonObject> FormatToolDefinition(
		const FString& Name,
		const FString& Description,
		const TSharedPtr<FJsonObject>& ParamSchema
	) const override;

protected:
	virtual FAICompletionResponse ParseResponse(const FString& ResponseBody) override;
	virtual FString GetModelsEndpoint() const override;
	virtual TMap<FString, FString> GetAuthHeaders() const override;

private:
	/** Delegate to the actual format-specific provider */
	TSharedPtr<IAIProvider> InnerProvider;

	FString Endpoint;
	FString ApiKey;
	FString Model;
	EAIProviderType Format;
};
