// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "AI/AIProviderBase.h"

/**
 * AI provider implementation for Anthropic Claude API.
 * Endpoint: https://api.anthropic.com/v1/messages
 * Supports tool_use content blocks for function calling.
 */
class FClaudeProvider : public FAIProviderBase
{
public:
	FClaudeProvider(const FString& InApiKey, const FString& InModel, const FString& InApiVersion);

	virtual FString GetProviderName() const override { return TEXT("Claude"); }
	virtual bool SupportsToolCalling() const override { return true; }

	virtual void SendRequest(
		const FAICompletionRequest& Request,
		FOnAIResponse OnResponse,
		FOnAIError OnError
	) override;

	virtual TSharedPtr<FJsonObject> FormatToolDefinition(
		const FString& Name,
		const FString& Description,
		const TSharedPtr<FJsonObject>& ParamSchema
	) const override;

protected:
	virtual FAICompletionResponse ParseResponse(const FString& ResponseBody) override;
	virtual FString GetModelsEndpoint() const override;
	virtual TMap<FString, FString> GetAuthHeaders() const override;
	virtual TArray<FModelInfo> ParseModelListResponse(const FString& ResponseBody) const override;

private:
	/** Build the messages array in Claude's format */
	TArray<TSharedPtr<FJsonValue>> BuildMessages(const TArray<FAIMessage>& Messages) const;

	FString ApiKey;
	FString Model;
	FString ApiVersion;
};
