// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#include "Settings/BlueprintAISettings.h"
#include "BlueprintAIAssistantModule.h"

UBlueprintAISettings::UBlueprintAISettings()
{
	ClaudeModel = TEXT("claude-sonnet-4-20250514");
	ClaudeApiVersion = TEXT("2023-06-01");

	OpenAIModel = TEXT("gpt-4o");
	OpenAIEndpoint = TEXT("https://api.openai.com/v1/responses");

	OpenRouterModel = TEXT("anthropic/claude-sonnet-4-20250514");

	CustomEndpoint = TEXT("");
	CustomModel = TEXT("");

	EndpointReference = FText::FromString(
		TEXT("OpenAI Chat (GPT-4o, o3, o4-mini):\n")
		TEXT("  https://api.openai.com/v1/chat/completions\n\n")
		TEXT("OpenAI Codex / Responses API (gpt-5.3-codex):\n")
		TEXT("  https://api.openai.com/v1/responses\n\n")
		TEXT("Anthropic Claude (direct):\n")
		TEXT("  https://api.anthropic.com/v1/messages\n\n")
		TEXT("OpenRouter (any model):\n")
		TEXT("  https://openrouter.ai/api/v1/chat/completions")
	);
}

UBlueprintAISettings* UBlueprintAISettings::Get()
{
	return GetMutableDefault<UBlueprintAISettings>();
}

#if WITH_EDITOR
FText UBlueprintAISettings::GetSectionText() const
{
	return NSLOCTEXT("BlueprintAI", "SettingsSection", "Blueprint AI Assistant");
}

FText UBlueprintAISettings::GetSectionDescription() const
{
	return NSLOCTEXT("BlueprintAI", "SettingsDesc",
		"Configure AI providers and behavior for the Blueprint AI Assistant plugin.");
}

void UBlueprintAISettings::PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent)
{
	Super::PostEditChangeProperty(PropertyChangedEvent);

	// Auto-save and refresh the provider so API key / endpoint / model changes
	// take effect immediately without restarting the editor.
	SaveConfig();

	if (FModuleManager::Get().IsModuleLoaded(TEXT("BlueprintAIAssistant")))
	{
		FBlueprintAIAssistantModule::Get().RefreshAIProvider();
	}
}
#endif
