// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#include "Actions/SaveMemoryAction.h"
#include "Memory/BlueprintAIMemory.h"

TSharedPtr<FJsonObject> FSaveMemoryAction::GetParameterSchema() const
{
	TSharedPtr<FJsonObject> Schema = MakeShared<FJsonObject>();
	Schema->SetStringField(TEXT("type"), TEXT("object"));

	TSharedPtr<FJsonObject> Props = MakeShared<FJsonObject>();

	TSharedPtr<FJsonObject> ContentProp = MakeShared<FJsonObject>();
	ContentProp->SetStringField(TEXT("type"), TEXT("string"));
	ContentProp->SetStringField(TEXT("description"),
		TEXT("The fact, preference, or convention to remember across sessions. "
			"Be specific and actionable (e.g. 'User prefers blueprints in /Game/Gameplay/' or "
			"'Project uses BP_ prefix for all Blueprint assets')."));
	Props->SetObjectField(TEXT("content"), ContentProp);

	Schema->SetObjectField(TEXT("properties"), Props);

	TArray<TSharedPtr<FJsonValue>> Required;
	Required.Add(MakeShared<FJsonValueString>(TEXT("content")));
	Schema->SetArrayField(TEXT("required"), Required);

	return Schema;
}

FBlueprintActionResult FSaveMemoryAction::Execute(const TSharedPtr<FJsonObject>& Params)
{
	FString Content = Params->GetStringField(TEXT("content"));
	if (Content.IsEmpty())
	{
		return FBlueprintActionResult::Failure(TEXT("content is required"));
	}

	FString MemoryId = FBlueprintAIMemory::Get().AddMemory(Content);

	TSharedPtr<FJsonObject> ResultData = MakeShared<FJsonObject>();
	ResultData->SetStringField(TEXT("memory_id"), MemoryId);
	ResultData->SetStringField(TEXT("content"), Content);

	return FBlueprintActionResult::Success(
		FString::Printf(TEXT("Memory saved as %s: '%s'"), *MemoryId, *Content.Left(100)),
		ResultData
	);
}
