// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#include "Actions/IBlueprintAction.h"
#include "Serialization/JsonSerializer.h"
#include "Serialization/JsonWriter.h"

FString FBlueprintActionResult::ToJsonString() const
{
	TSharedRef<FJsonObject> Root = MakeShared<FJsonObject>();
	Root->SetBoolField(TEXT("success"), bSuccess);
	Root->SetStringField(TEXT("message"), Message);

	if (Data.IsValid())
	{
		Root->SetObjectField(TEXT("data"), Data);
	}

	FString Output;
	TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&Output);
	FJsonSerializer::Serialize(Root, Writer);
	return Output;
}
