// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

using UnrealBuildTool;

public class BlueprintAIAssistant : ModuleRules
{
	public BlueprintAIAssistant(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

		PublicDependencyModuleNames.AddRange(new string[]
		{
			"Core",
			"CoreUObject",
			"Engine",
			"InputCore",
		});

		PrivateDependencyModuleNames.AddRange(new string[]
		{
			// Settings
			"DeveloperSettings",

			// Editor
			"UnrealEd",
			"BlueprintGraph",
			"KismetCompiler",
			"Kismet",
			"GraphEditor",
			"AssetTools",
			"AssetRegistry",

			// HTTP & JSON
			"HTTP",
			"Json",
			"JsonUtilities",

			// UI
			"Slate",
			"SlateCore",
			"EditorFramework",
			"ToolMenus",
			"WorkspaceMenuStructure",
			"Projects",
			"EditorWidgets",
			"PropertyEditor",
		});
	}
}
