(() => {
    const tipsByName = {
        site_name: 'Public website title shown in header, browser title, and metadata.',
        site_tagline: 'Short subtitle shown below the site name.',
        legal_email: 'Primary legal/support contact email used across policy pages and forms.',
        site_meta_description: 'Default SEO description used when a page-specific description is not set.',
        brand_display_mode: 'Choose how branding appears in the header: name, favicon, or both.',
        site_favicon_url: 'Optional static favicon path, for example /assets/favicon.ico.',
        site_favicon_file: 'Upload a favicon file (.ico/.png/.webp). Max size: 1 MB.',
        cursor_theme_enabled: 'Enable themed cursor visuals for normal and hover states.',
        pagination_per_page: 'How many items are listed per paginated page (threads/results).',

        about_page_content: 'Editable content for the public About page.',
        dmca_page_content: 'Editable content for the public DMCA policy page.',
        legal_page_content: 'Editable content for the public Legal page.',
        terms_page_content: 'Editable content for the Terms of Service page.',
        privacy_page_content: 'Editable content for the Privacy Policy page.',
        legal_notice_page_content: 'Editable content for the Legal Notice page.',

        post_disclaimer_enabled: 'When enabled, users must accept a disclaimer before viewing post pages.',
        post_disclaimer_title: 'Title shown at the top of the post disclaimer.',
        post_disclaimer_body: 'Main disclaimer text shown before entering post pages.',

        board_default_max_files: 'Default max files per single post/comment upload submission.',
        board_default_max_file_mb: 'Default max size per uploaded file in megabytes.',
        board_default_cooldown_seconds: 'Default minimum seconds a user must wait between posting in the same board.',
        board_default_max_posts_per_hour: 'Default posting limit per user per board per hour.',
        board_default_max_comments_per_hour: 'Default comment limit per user per board per hour.',
        board_default_captcha_mode: 'Default CAPTCHA policy used by boards unless overridden.',
        auto_approve_new_posts: 'When enabled, new posts are published immediately. When disabled, new posts go to the Pending Posts queue for admin approval.',

        anti_spam_posts_per_10m: 'Global anti-spam cap for posts per user/IP every 10 minutes.',
        anti_spam_comments_per_10m: 'Global anti-spam cap for comments per user/IP every 10 minutes.',
        anti_spam_contact_per_hour: 'Global anti-spam cap for contact submissions per hour.',
        low_trust_age_hours: 'Account age threshold for low-trust checks.',
        low_trust_min_activity: 'Minimum activity (posts+comments) needed to leave low-trust mode.',

        robots_custom_rules: 'Raw robots.txt content. If empty, default safe rules are served.',
        sitemap_auto_ping_enabled: 'Automatically notify sitemap services on content changes.',
        sitemap_ping_services: 'One endpoint per line. Use {sitemap_url} placeholder in each URL.',

        smtp_host: 'SMTP server host used for transactional emails.',
        smtp_port: 'SMTP server port, commonly 587 (TLS) or 465 (SSL).',
        smtp_username: 'SMTP login username.',
        smtp_password: 'SMTP password; leave empty to keep the current saved password.',
        smtp_security: 'Connection security mode: TLS, SSL, or none.',
        smtp_from_email: 'From address used for outgoing SMTP emails.',
        email_verification_enabled: 'Require email verification before users can login.',
        password_reset_enabled: 'Allow users to request password reset emails.',
        contact_forward_enabled: 'Forward contact form submissions by email via SMTP.',
        registration_enabled: 'Allow public user sign-ups.',

        target_email: 'Destination address used to send the SMTP test message.'
    };

    const labels = document.querySelectorAll('.settings-form label');
    labels.forEach((label) => {
        const field = label.querySelector('input[name], select[name], textarea[name]');
        if (!field || label.querySelector('.setting-tip')) {
            return;
        }

        const name = (field.getAttribute('name') || '').trim();
        const tip = tipsByName[name] || 'Hover for a short explanation of this setting.';

        const icon = document.createElement('span');
        icon.className = 'setting-tip';
        icon.textContent = 'ⓘ';
        icon.setAttribute('data-tip', tip);
        icon.setAttribute('title', tip);
        icon.setAttribute('role', 'img');
        icon.setAttribute('aria-label', tip);
        icon.setAttribute('tabindex', '0');

        label.appendChild(icon);
    });
})();
